jQuery(document).ready(function($) {
    
    // Tab switching
    $('.tab-button').on('click', function() {
        var tab = $(this).data('tab');
        $('.tab-button').removeClass('active');
        $(this).addClass('active');
        $('.tab-content').removeClass('active');
        $('#' + tab).addClass('active');
    });
    
    // Load stats on page load
    loadStats();
    
    function loadStats() {
        $.ajax({
            url: seoOptAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'seo_opt_get_stats',
                nonce: seoOptAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('#broken-links-count').text(response.data.broken_links);
                    $('#images-count').text(response.data.images);
                    $('#db-size').text(response.data.db_size + ' MB');
                    $('#cleanup-items').text(response.data.cleanup_items);
                    $('#monitor-db-size').text(response.data.db_size + ' MB');
                    $('#monitor-revisions').text(response.data.revisions);
                    $('#monitor-autodrafts').text(response.data.autodrafts);
                    $('#monitor-trash').text(response.data.trash);
                    $('#monitor-spam').text(response.data.spam);
                    $('#monitor-transients').text(response.data.transients);
                    $('#last-scan-date').text(response.data.last_scan);
                }
            }
        });
    }
    
    // Check support button
    $('#check-support-btn').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).text('Checking...');
        
        $.ajax({
            url: seoOptAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'seo_opt_check_support',
                nonce: seoOptAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    var info = response.data;
                    var html = '<h4>Server Configuration Details:</h4><ul>';
                    html += '<li><strong>PHP Version:</strong> ' + info.php_version + '</li>';
                    html += '<li><strong>GD Library:</strong> ' + (info.gd_installed ? 'Installed' : 'NOT Installed') + '</li>';
                    html += '<li><strong>WebP Support:</strong> ' + (info.webp_support ? '✓ YES' : '✗ NO') + '</li>';
                    html += '<li><strong>AVIF Support:</strong> ' + (info.avif_support ? '✓ YES' : '✗ NO') + '</li>';
                    html += '<li><strong>Memory Limit:</strong> ' + info.memory_limit + '</li>';
                    html += '<li><strong>Max Execution Time:</strong> ' + info.max_execution_time + 's</li>';
                    html += '<li><strong>Max Upload Size:</strong> ' + info.upload_max_filesize + '</li>';
                    html += '</ul>';
                    
                    if (!info.webp_support && !info.avif_support) {
                        html += '<p style="color: red; font-weight: bold; margin-top: 15px;">⚠️ Your server does not support WebP or AVIF. Contact your hosting provider to enable GD library with image format support.</p>';
                    }
                    
                    $('#image-results').html(html).show();
                } else {
                    alert('Error checking support');
                }
            },
            complete: function() {
                $btn.prop('disabled', false).html('<span class="dashicons dashicons-info"></span> Check Detailed Support');
            }
        });
    });
    
    // Scan for broken links
    $('#scan-links-btn').on('click', function() {
        var $btn = $(this);
        var $progress = $('#scan-progress');
        var $progressFill = $progress.find('.progress-fill');
        var $progressText = $progress.find('.progress-text');
        
        $btn.prop('disabled', true);
        $progress.show();
        
        var progress = 0;
        var progressInterval = setInterval(function() {
            progress += Math.random() * 15;
            if (progress > 90) progress = 90;
            $progressFill.css('width', progress + '%');
        }, 500);
        
        $.ajax({
            url: seoOptAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'seo_opt_scan_links',
                nonce: seoOptAjax.nonce
            },
            success: function(response) {
                clearInterval(progressInterval);
                $progressFill.css('width', '100%');
                
                if (response.success) {
                    $progressText.text('Scan complete! Found ' + response.data.count + ' broken links.');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    alert('Error scanning links: ' + response.data);
                }
            },
            error: function() {
                clearInterval(progressInterval);
                alert('Error scanning links. Please try again.');
            },
            complete: function() {
                $btn.prop('disabled', false);
            }
        });
    });
    
    // Select all links checkbox
    $('#select-all-links').on('change', function() {
        $('.link-checkbox').prop('checked', $(this).is(':checked'));
    });
    
    // Fix single link
    $(document).on('click', '.fix-link-btn', function() {
        var $btn = $(this);
        var linkId = $btn.data('link-id');
        var action = $btn.data('action');
        
        if (!confirm('Are you sure you want to ' + (action === 'delete' ? 'delete' : 'redirect') + ' this link?')) {
            return;
        }
        
        $btn.prop('disabled', true).text('Processing...');
        
        $.ajax({
            url: seoOptAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'seo_opt_fix_links',
                nonce: seoOptAjax.nonce,
                link_ids: [linkId],
                fix_action: action
            },
            success: function(response) {
                if (response.success) {
                    $btn.closest('tr').fadeOut(400, function() {
                        $(this).remove();
                        if ($('#broken-links-tbody tr').length === 0) {
                            location.reload();
                        }
                    });
                    loadStats();
                } else {
                    alert('Error fixing link: ' + response.data);
                    $btn.prop('disabled', false).text($btn.data('action') === 'delete' ? 'Delete' : 'To Homepage');
                }
            },
            error: function() {
                alert('Error fixing link. Please try again.');
                $btn.prop('disabled', false).text($btn.data('action') === 'delete' ? 'Delete' : 'To Homepage');
            }
        });
    });
    
    // Apply bulk action
    $('#apply-bulk-action').on('click', function() {
        var action = $('#bulk-action-select').val();
        if (!action) {
            alert('Please select a bulk action.');
            return;
        }
        
        var selectedLinks = [];
        $('.link-checkbox:checked').each(function() {
            selectedLinks.push($(this).val());
        });
        
        if (selectedLinks.length === 0) {
            alert('Please select at least one link.');
            return;
        }
        
        var actionText = action === 'delete' ? 'delete' : 'redirect to homepage';
        if (!confirm('Are you sure you want to ' + actionText + ' ' + selectedLinks.length + ' link(s)?')) {
            return;
        }
        
        var $btn = $(this);
        $btn.prop('disabled', true).text('Processing...');
        
        $.ajax({
            url: seoOptAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'seo_opt_fix_links',
                nonce: seoOptAjax.nonce,
                link_ids: selectedLinks,
                fix_action: action
            },
            success: function(response) {
                if (response.success) {
                    alert('Successfully fixed ' + response.data.fixed_count + ' link(s).');
                    location.reload();
                } else {
                    alert('Error fixing links: ' + response.data);
                }
            },
            error: function() {
                alert('Error fixing links. Please try again.');
            },
            complete: function() {
                $btn.prop('disabled', false).text('Apply');
            }
        });
    });
    
    // Optimize images
    $('#optimize-images-btn').on('click', function() {
        var $btn = $(this);
        var $progress = $('#image-progress');
        var $progressFill = $progress.find('.progress-fill');
        var $progressText = $progress.find('.progress-text');
        var $results = $('#image-results');
        
        if (!confirm('This will convert all images to the selected format. This may take some time. Continue?')) {
            return;
        }
        
        $btn.prop('disabled', true);
        $progress.show();
        $results.html('');
        
        var progress = 0;
        var progressInterval = setInterval(function() {
            progress += Math.random() * 10;
            if (progress > 90) progress = 90;
            $progressFill.css('width', progress + '%');
        }, 1000);
        
        $.ajax({
            url: seoOptAjax.ajax_url,
            type: 'POST',
            timeout: 300000, // 5 minutes timeout
            data: {
                action: 'seo_opt_optimize_images',
                nonce: seoOptAjax.nonce
            },
            success: function(response) {
                clearInterval(progressInterval);
                $progressFill.css('width', '100%');
                
                if (response.success) {
                    $progressText.text('Optimization complete!');
                    
                    var html = '<h4>Image Optimization Results</h4>';
                    html += '<ul>';
                    html += '<li><strong>Total Images:</strong> ' + response.data.total + '</li>';
                    html += '<li><strong>Successfully Optimized:</strong> ' + response.data.optimized + '</li>';
                    html += '<li><strong>Skipped:</strong> ' + response.data.skipped + '</li>';
                    html += '</ul>';
                    
                    // Show errors if any
                    if (response.data.errors && response.data.errors.length > 0) {
                        html += '<h4 style="color: red; margin-top: 15px;">Errors:</h4><ul>';
                        response.data.errors.forEach(function(error) {
                            html += '<li style="color: red;">' + error + '</li>';
                        });
                        html += '</ul>';
                    }
                    
                    // Show detailed log
                    if (response.data.details && response.data.details.length > 0) {
                        html += '<h4 style="margin-top: 15px;">Detailed Log:</h4>';
                        html += '<div style="background: #f5f5f5; padding: 10px; border-radius: 4px; max-height: 300px; overflow-y: auto; font-family: monospace; font-size: 12px;">';
                        response.data.details.forEach(function(detail) {
                            html += detail + '<br>';
                        });
                        html += '</div>';
                    }
                    
                    $results.html(html).show();
                    loadStats();
                } else {
                    $results.addClass('error').html('<h4>Error</h4><p>' + response.data + '</p>').show();
                }
            },
            error: function(xhr, status, error) {
                clearInterval(progressInterval);
                var errorMsg = 'Failed to optimize images. ';
                if (status === 'timeout') {
                    errorMsg += 'Request timed out. Try optimizing fewer images or contact your hosting provider.';
                } else {
                    errorMsg += 'Error: ' + error;
                }
                $results.addClass('error').html('<h4>Error</h4><p>' + errorMsg + '</p>').show();
            },
            complete: function() {
                $btn.prop('disabled', false);
                setTimeout(function() {
                    $progress.hide();
                }, 2000);
            }
        });
    });
    
    // Save image settings
    $('#save-image-settings').on('click', function() {
        var format = $('#auto-convert-format').val();
        var quality = $('#image-quality').val();
        
        var $btn = $(this);
        $btn.prop('disabled', true).text('Saving...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'update_option',
                option_name: 'seo_opt_auto_convert',
                option_value: format,
                _wpnonce: seoOptAjax.nonce
            },
            success: function() {
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'update_option',
                        option_name: 'seo_opt_image_quality',
                        option_value: quality,
                        _wpnonce: seoOptAjax.nonce
                    },
                    success: function() {
                        alert('Settings saved successfully!');
                        location.reload();
                    }
                });
            },
            error: function() {
                alert('Error saving settings. Please try again.');
            },
            complete: function() {
                $btn.prop('disabled', false).text('Save Settings');
            }
        });
    });
    
    // Cleanup database
    $('#cleanup-database-btn').on('click', function() {
        var cleanupItems = [];
        $('.cleanup-checkbox:checked').each(function() {
            cleanupItems.push($(this).val());
        });
        
        if (cleanupItems.length === 0) {
            alert('Please select at least one item to clean.');
            return;
        }
        
        if (!confirm('This will permanently delete the selected items. Continue?')) {
            return;
        }
        
        var $btn = $(this);
        var $results = $('#cleanup-results');
        
        $btn.prop('disabled', true).text('Cleaning...');
        $results.html('');
        
        $.ajax({
            url: seoOptAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'seo_opt_cleanup_database',
                nonce: seoOptAjax.nonce,
                cleanup_items: cleanupItems
            },
            success: function(response) {
                if (response.success) {
                    var html = '<h4>Database Cleanup Results</h4>';
                    html += '<ul>';
                    
                    if (response.data.revisions !== undefined) {
                        html += '<li><strong>Post Revisions Deleted:</strong> ' + response.data.revisions + '</li>';
                    }
                    if (response.data.autodrafts !== undefined) {
                        html += '<li><strong>Auto-Drafts Deleted:</strong> ' + response.data.autodrafts + '</li>';
                    }
                    if (response.data.trash !== undefined) {
                        html += '<li><strong>Trashed Posts Deleted:</strong> ' + response.data.trash + '</li>';
                    }
                    if (response.data.spam !== undefined) {
                        html += '<li><strong>Spam Comments Deleted:</strong> ' + response.data.spam + '</li>';
                    }
                    if (response.data.trashed_comments !== undefined) {
                        html += '<li><strong>Trashed Comments Deleted:</strong> ' + response.data.trashed_comments + '</li>';
                    }
                    if (response.data.transients !== undefined) {
                        html += '<li><strong>Expired Transients Deleted:</strong> ' + response.data.transients + '</li>';
                    }
                    if (response.data.orphaned_meta !== undefined) {
                        html += '<li><strong>Orphaned Meta Deleted:</strong> ' + response.data.orphaned_meta + '</li>';
                    }
                    
                    html += '</ul>';
                    html += '<p><strong>Database has been optimized!</strong></p>';
                    
                    $results.html(html).show();
                    loadStats();
                } else {
                    $results.addClass('error').html('<h4>Error</h4><p>' + response.data + '</p>').show();
                }
            },
            error: function() {
                $results.addClass('error').html('<h4>Error</h4><p>Failed to cleanup database. Please try again.</p>').show();
            },
            complete: function() {
                $btn.prop('disabled', false).text('Clean Database');
            }
        });
    });
    
});